unit mainform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, TrlKey, Trlware, TrialMon, TrlTools, Buttons,
  ComCtrls;

type
  TMainForm1 = class(TForm)
    TrialMonitor1: TTrialMonitor;
    RadioGroup1: TRadioGroup;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    StatusBar1: TStatusBar;
    procedure BitBtn1Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Edit3Exit(Sender: TObject);
    procedure TrialMonitor1CodeFail(Sender: TObject);
    procedure TrialMonitor1CodePass(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure Edit3Enter(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm1: TMainForm1;

  enforce: array[0..7] of TEnforce = (eTReg,eTDays,eTDate,eTUse,eTDaysTDate,eTDaysTUse,eTDateTUse,eTDaysTDateTUse);

implementation

uses linkform;

{$R *.DFM}

procedure TMainForm1.BitBtn1Click(Sender: TObject);
var Dlg: TTrialLinkForm;
begin
 Dlg := TTrialLinkForm.Create(nil);
 Dlg.TrialFormLink1.UserNameEdit.Text := TrialMonitor1.UserName;
 Dlg.TrialFormLink1.UserRegCodeEdit.Text := TrialMonitor1.UserCode;
 TrialMonitor1.NewRegistration(Dlg.TrialFormLink1);
 Dlg.Free;
 Update
end;

procedure TMainForm1.RadioGroup1Click(Sender: TObject);
begin
 TrialMonitor1.EnforceLimits := enforce[RadioGroup1.ItemIndex]
end;

procedure TMainForm1.Edit1Change(Sender: TObject);
begin
 if (ActiveControl=Sender) then
  with TrialMonitor1 do
   try
    DayCountLimit := strToInt(Edit1.Text);
   except
    DayCountLimit := 3
   end;
 Edit1.Text := intToStr(TrialMonitor1.DayCountLimit)
end;

procedure TMainForm1.Edit2Change(Sender: TObject);
begin
 if (ActiveControl=Sender) then
  with TrialMonitor1 do
   try
    UseCountLimit := strToInt(Edit2.Text)
   except
    UseCountLimit := 10
   end;
 Edit2.Text := intToStr(TrialMonitor1.UseCountLimit)
end;

procedure TMainForm1.Edit3Exit(Sender: TObject);
begin
 with TrialMonitor1 do
  try
   DropDeadDate := Edit3.Text
  except
   DropDeadDate := DateToStr(Now + 1)    //tomorrow
  end;
 Edit3.Text := TrialMonitor1.DropDeadDate
end;

procedure TMainForm1.TrialMonitor1CodeFail(Sender: TObject);
begin    // the code did not pass but could be in Trial Mode
 if TrialMonitor1.IsRegistered then
  ShowMessage('Passed in trial mode: EnforceLimits = '+RadioGroup1.Items[RadioGroup1.ItemIndex])
 else
  ShowMessage(TrialMonitor1.UserCode+' is not correct: EnforceLimits = '+RadioGroup1.Items[RadioGroup1.ItemIndex]);
 TrialMonitor1.ReLoad;     // new method (use sparingly)
end;

procedure TMainForm1.TrialMonitor1CodePass(Sender: TObject);
begin    // this will only be executed when the code is correct
 ShowMessage('Passed with good code: EnforceLimits = '+RadioGroup1.Items[RadioGroup1.ItemIndex])
end;

procedure TMainForm1.FormPaint(Sender: TObject);
begin
 StatusBar1.Panels[0].Text := 'Days Used: '+TrialMonitor1.DaysUsed.AsString;
 StatusBar1.Panels[1].Text  := 'Times Used: '+TrialMonitor1.TimesUsed.AsString;
 StatusBar1.Panels[2].Text  := 'Use Until: '+TrialMonitor1.DropDeadDate
end;

procedure TMainForm1.Edit3Enter(Sender: TObject);
begin
 Edit3.Text := FormatDateTime('mm/dd/yyyy',Now)
end;

procedure TMainForm1.FormActivate(Sender: TObject);
begin
 TrialMonitor1.DropDeadDate := '01/01/2000';
 TrialMonitor1.UseCountLimit := 10;
 TrialMonitor1.DayCountLimit := 3
end;

end.
